/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.apache.commons.io.IOUtils;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.repository.BookRepository;

public class FileRepository
extends BookRepository {
    public final class_2960 location;

    public FileRepository(class_2960 location) {
        this.location = location;
    }

    @Override
    public List<SectionData> getSections() {
        return new ArrayList<SectionData>(Arrays.asList((SectionData[])BookLoader.getGson().fromJson(this.resourceToString(this.getResource(this.getResourceLocation("index.json"))), SectionData[].class)));
    }

    @Override
    public class_2960 getResourceLocation(@Nullable String path, boolean safe) {
        if (path == null) {
            return safe ? new class_2960("") : null;
        }
        if (!path.contains(":")) {
            class_2960 res;
            String langPath = null;
            if (class_310.method_1551().method_1526() != null && class_310.method_1551().method_1526().method_4669() != null) {
                langPath = class_310.method_1551().method_1526().method_4669();
            }
            String defaultLangPath = "en_us";
            if (langPath != null && this.resourceExists(res = new class_2960(String.valueOf(this.location) + "/" + langPath + "/" + path))) {
                return res;
            }
            res = new class_2960(String.valueOf(this.location) + "/" + defaultLangPath + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
            res = new class_2960(String.valueOf(this.location) + "/" + path);
            if (this.resourceExists(res)) {
                return res;
            }
        } else {
            class_2960 res = new class_2960(path);
            if (this.resourceExists(res)) {
                return res;
            }
        }
        return safe ? new class_2960("") : null;
    }

    @Override
    public class_3298 getResource(@Nullable class_2960 loc) {
        if (loc == null) {
            return null;
        }
        return class_310.method_1551().method_1478().method_14486(loc).orElse(null);
    }

    @Override
    public boolean resourceExists(@Nullable class_2960 location) {
        if (location == null) {
            return false;
        }
        return class_310.method_1551().method_1478().method_14486(location).isPresent();
    }

    @Override
    public String resourceToString(@Nullable class_3298 resource, boolean skipComments) {
        if (resource == null) {
            return "";
        }
        try {
            Iterator iterator = IOUtils.readLines((InputStream)resource.method_14482(), (Charset)StandardCharsets.UTF_8).iterator();
            StringBuilder builder = new StringBuilder();
            boolean isLongComment = false;
            while (iterator.hasNext()) {
                String s = ((String)iterator.next()).trim() + "\n";
                if (skipComments) {
                    if (isLongComment) {
                        if (!s.endsWith("*/")) continue;
                        isLongComment = false;
                        continue;
                    }
                    if (s.startsWith("/*")) {
                        isLongComment = true;
                        continue;
                    }
                    if (s.startsWith("//")) continue;
                }
                builder.append(s);
            }
            return builder.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

